VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} TemplateDlg 
   Caption         =   "New Drawing"
   ClientHeight    =   5760
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6045
   OleObjectBlob   =   "TemplateDlg.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "TemplateDlg"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'    This is a part of the source code for Pro/DESKTOP.
'    Copyright (C) 1999-2001 Parametric Technology Corporation.
'    All rights reserved.

Option Explicit

Private app As ProDESKTOP

Private TemplateFolder As String

Private Type Template
    Button As Object
    FileName As String
    Description As String
    Flags As Integer
End Type

Const flgNoDesign As Integer = 0
Const flgSelectDesign As Integer = 1
Const flgNewDesign As Integer = 2

Const nButtons As Integer = 6
Private TemplateList(1 To nButtons) As Template
Private DesignList As New Collection


Private Sub UserForm_Initialize()

    Me.OKButton.Caption = GetResourceString(91)
    Me.CancelButton.Caption = GetResourceString(92)
    Me.TemplateLabel.Caption = GetResourceString(503)
    Me.TemplateFileLabel.Caption = GetResourceString(504)
    Me.DesignOption1.Caption = GetResourceString(505)
    Me.DesignOption2.Caption = GetResourceString(506)
    Me.DesignsLabel.Caption = GetResourceString(507)
    Me.Caption = GetResourceString(508)
    
    Set app = GetApp
    TemplateFolder = app.GetAppExecutablePath() & "\Drawing Formats\"
    
    SetupTemplateList
    SetupDesigns

End Sub

Private Sub SetupTemplateList()

    Set TemplateList(1).Button = Template1
    Set TemplateList(2).Button = Template2
    Set TemplateList(3).Button = Template3
    Set TemplateList(4).Button = Template4
    Set TemplateList(5).Button = Template5
    Set TemplateList(6).Button = Template6
    
    Dim file As String
    Dim bitmap As String
    Dim descr As String
    Dim flgs As String

    Dim i As Integer
    i = 0
    
    Open TemplateFolder & "Templates.lst" For Input As #1
    Do While Not EOF(1)
        i = i + 1
        
        Input #1, file, bitmap, descr
        
        TemplateList(i).FileName = file
        TemplateList(i).Description = descr
        TemplateList(i).Button.Picture = LoadPicture(TemplateFolder & bitmap)
        Do
            Input #1, flgs
            If flgs = "NoDesign" Then
                TemplateList(i).Flags = flgNoDesign
            ElseIf flgs = "NewDesign" Then
                TemplateList(i).Flags = flgNewDesign
            ElseIf flgs = "SelectDesign" Then
                TemplateList(i).Flags = flgSelectDesign
            End If
        Loop Until flgs = "" Or EOF(1)
    Loop
    Close #1

End Sub

Private Sub SetupDesigns()

    Dim quads As ObjectSet
    Set quads = app.GetSession.GetQuads

    Dim it As iterator
    Set it = app.GetClass("it").CreateAObjectIt(quads)

    Dim visited As ObjectSet
    Set visited = app.GetClass("ObjectSet").CreateAObjectSet()

    Dim designDoc As GraphicDocument, activeDesign As aDesign
    On Error Resume Next
    Set designDoc = app.GetActiveDoc
    Set activeDesign = designDoc.GetDesign
'    On Error GoTo 0

    Designs.Clear

    Dim i As Integer
    For i = 1 To DesignList.Count
        DesignList.Remove 1
    Next

    i = 0
    
    it.start
    Do While it.IsActive
        Dim design As aDesign
        Set design = it.Current.GetActiveDesign
        
        If design.IsA("DesignInstance") Or design.IsA("DesignOcc") Then
            Set design = design.GetMaster
        End If

        ' there can be more than one window of a design
        If visited.Contains(design) = 0 Then    ' bug in .Contains - returns C++ style boolean so test with zero
            Dim title As String
            On Error GoTo endLoop
            Dim file As aFile
            Set file = design.GetFile
            If file Is Nothing Or file.GetDocument Is Nothing Then
                GoTo endLoop
            End If
            title = file.GetTitle
            If title = "" Then  ' document hasn't been saved
                title = file.GetDocument.GetTitle
            End If
            
            Designs.AddItem title
            visited.AddMember design
            
            If Not activeDesign Is Nothing Then
                If AObjectsAreEqual(design, activeDesign) Then   ' make this default selection
                    Designs.ListIndex = i
                End If
            End If

            i = i + 1
            
            DesignList.Add design
        End If

endLoop:
        it.Next
    Loop
    
    If i = 1 Then
        Designs.ListIndex = 0
    End If

End Sub

Private Function GetTemplate() As Integer

    Dim i As Integer
    For i = 1 To nButtons
        If TemplateList(i).Button.SpecialEffect = fmSpecialEffectSunken Then
            GetTemplate = i
            Exit Function
        End If
    Next
    GetTemplate = 0
    
End Function

Private Sub UserForm_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = ""
End Sub
Private Sub Template1_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(1).Description
End Sub

Private Sub Template2_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(2).Description
End Sub

Private Sub Template3_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(3).Description
End Sub

Private Sub Template4_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(4).Description
End Sub

Private Sub Template5_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(5).Description
End Sub

Private Sub Template6_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    Description.Caption = TemplateList(6).Description
End Sub

Private Sub Template1_Click()
    ButtonPress 1
End Sub

Private Sub Template2_Click()
    ButtonPress 2
End Sub

Private Sub Template3_Click()
    ButtonPress 3
End Sub

Private Sub Template4_Click()
    ButtonPress 4
End Sub

Private Sub Template5_Click()
    ButtonPress 5
End Sub

Private Sub Template6_Click()
    ButtonPress 6
End Sub

Private Sub ButtonPress(Button As Integer)
    Dim i As Integer, effect As Integer
    For i = 1 To nButtons
        If i = Button Then
            effect = fmSpecialEffectSunken
        Else
            effect = fmSpecialEffectRaised
        End If
        TemplateList(i).Button.SpecialEffect = effect
    Next

    TemplateFile.Value = TemplateFolder & TemplateList(Button).FileName

    Dim optEnabled As Boolean, desEnabled As Boolean
    optEnabled = (TemplateList(Button).Flags <> flgNoDesign)
    desEnabled = (TemplateList(Button).Flags = flgSelectDesign)

    DesignOption1.Visible = optEnabled
    DesignOption2.Visible = optEnabled
    Designs.Visible = desEnabled
    DesignsLabel.Visible = desEnabled
    
    If desEnabled Then
        DesignOption2 = True
    Else
        DesignOption1 = True
    End If
End Sub

Private Sub DesignOption1_Click()
    DesignOption1.Value = True
    DesignOption2.Value = False
    Designs.Visible = False
    DesignsLabel.Visible = False
End Sub

Private Sub DesignOption2_Click()
    DesignOption1.Value = False
    DesignOption2.Value = True
    Designs.Visible = True
    DesignsLabel.Visible = True
End Sub

Private Sub CancelButton_Click()
    Hide
End Sub

Private Sub OKButton_Click()

    On Error GoTo errorHandler

    Dim t As Integer
    t = GetTemplate()
    
    If t = 0 Then
        MsgBox GetResourceString(501)
        Exit Sub
    End If
    
    Dim design As aDesign
    If Designs.Visible Then
        If Designs.ListIndex = -1 Then
            MsgBox GetResourceString(502)
            Exit Sub
        End If
        Set design = DesignList(Designs.ListIndex + 1)
    End If

    Dim file As String
    file = Dir(TemplateFile.Value)

    If file <> "" Then
        ExecuteTemplate TemplateFile.Value, design
        Hide
    Else
        MsgBox GetResourceString(510)
    End If
    
    On Error GoTo 0
Exit Sub

errorHandler:
    Me.Hide
    MsgBox GetResourceString(96)

End Sub

Private Function AObjectsAreEqual(obj1 As aObject, obj2 As aObject) As Boolean
    
    Dim objset As ObjectSet
    Set objset = app.GetClass("ObjectSet").CreateAObjectSet()
    objset.AddMember obj1

    AObjectsAreEqual = objset.Contains(obj2)
    
End Function

